﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Xml;

public partial class Admin_LunTan_TieZhi_ZengJia : System.Web.UI.Page
{
    private 访问 访问;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("增加贴子", "网站后台", "增加贴子", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            增加贴子();
        else
            初始化();
    }

    private void 初始化()
    {
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[所属版块],[版块名称] FROM [" + 程序.数据表前缀 + "社区_论坛_版块]", 访问.连接);
        DataSet 数据 = new DataSet();
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "版块");

        生成列表(数据, 0, 1);

        MoBan_TieZhiNeiRong.Items.Add(new ListItem("==选择模板==", "0"));
        MoBan_HuiTieLieBiao.Items.Add(new ListItem("==选择模板==", "0"));
        MoBan_3GTieZhiNeiRong.Items.Add(new ListItem("==选择模板==", "0"));
        MoBan_3GHuiTieLieBiao.Items.Add(new ListItem("==选择模板==", "0"));

        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Club/" + 程序.设置["默认社区模板"] + "/Club/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
        {
            int ID = 0;
            String 模板名称 = "";
            String 模板类型 = "";
            bool 是否WAP = true;

            XmlReader _读取 = XmlReader.Create(FIS[i].OpenRead());
            while (_读取.Read())
                if (_读取.NodeType == XmlNodeType.Element)
                    if (_读取.GetAttribute("name") == "ID")
                        ID = Convert.ToInt32(_读取.GetAttribute("value"));
                    else if (_读取.GetAttribute("name") == "模板名称")
                        模板名称 = _读取.GetAttribute("value");
                    else if (_读取.GetAttribute("name") == "模板类型")
                        模板类型 = _读取.GetAttribute("value");
                    else if (_读取.GetAttribute("name") == "是否WAP")
                        是否WAP = Convert.ToBoolean(_读取.GetAttribute("value"));
            _读取.Close();

            switch (模板类型)
            {
                case "贴子内容":
                    if (是否WAP)
                        MoBan_TieZhiNeiRong.Items.Add(new ListItem(模板名称, ID.ToString()));
                    else
                        MoBan_3GTieZhiNeiRong.Items.Add(new ListItem(模板名称, ID.ToString()));
                    break;
                case "回贴列表":
                    if (是否WAP)
                        MoBan_HuiTieLieBiao.Items.Add(new ListItem(模板名称, ID.ToString()));
                    else
                        MoBan_3GHuiTieLieBiao.Items.Add(new ListItem(模板名称, ID.ToString()));
                    break;
            }
        }

        语句 = new SqlCommand("SELECT [ID] FROM [" + 程序.数据表前缀 + "社区_用户_用户] WHERE [用户类型]=@用户类型", 访问.连接);
        语句.Parameters.Add("@用户类型", SqlDbType.NVarChar).Value = "会员";
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            ZuoZheID.Text = 读取["ID"].ToString();
        读取.Close();
    }

    private void 生成列表(DataSet 数据, int 父版块, int 深度)
    {
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (Convert.ToInt32(行["所属版块"]) == 父版块)
            {
                ListItem 列表项 = new ListItem(生成空格(深度) + Convert.ToString(行["版块名称"]), Convert.ToString(行["ID"]));
                SuoShuBanKuai.Items.Add(列表项);
                生成列表(数据, Convert.ToInt32(行["ID"]), 深度 + 1);
            }
        }
    }

    private String 生成空格(int 数量)
    {
        String 返回值 = "";
        for (int i = 0; i < 数量; i++)
            返回值 += "　";
        return 返回值 + "|-";
    }

    private String 保存文件(int ZGID, int 贴子类型)
    {
        if (贴子类型 != 1)
            return "";

        String 返回值 = "";
        for (int i = 0; i < Request.Files.Count; i++)
        {
            HttpPostedFile HF = Request.Files[i];
            if (HF.ContentLength < 1)
                break;
            String 后缀=Path.GetExtension(HF.FileName).Substring(1);
            if (常用.是否允许后缀(Convert.ToString(程序.设置["资源文件_允许上传的文件类型"]), 后缀))
            {
                String 文件夹位置 = 程序.安装位置 + "Data/DT_TieZhi/F" + (ZGID /500) + "/";
                if (!Directory.Exists(Server.MapPath(文件夹位置)))
                    Directory.CreateDirectory(Server.MapPath(文件夹位置));
                文件夹位置 += "T"+ZGID+常用.随机字符(30) + "." + 后缀;
                HF.SaveAs(Server.MapPath(文件夹位置));
                返回值 += 返回值 == "" ? "" : ",";
                返回值 += 文件夹位置;
            }
        }
        return 返回值;
    }

    private String 获取版块名称(int ID)
    {
        String 返回值 = "";

        SqlCommand 语句 = new SqlCommand("SELECT [版块名称] FROM [" + 程序.数据表前缀 + "社区_论坛_版块] WHERE [ID]=" + ID, 访问.连接);
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
            返回值 = Convert.ToString(读取["版块名称"]);
        else
        {
            读取.Close();
            throw new Exception("版块不存在");
        }
        读取.Close();
        return 返回值;
    }

    private void 增加贴子()
    {
        访问.验证权限("33");
        if (SuoShuBanKuai.SelectedValue == null || SuoShuBanKuai.SelectedValue == "")
            throw new Exception("请先选择要发表到的版块");
        int ZGID=常用.SQL_最高ID(访问.连接,程序.数据表前缀+"社区_论坛_贴子");
        String 标题 = BiaoTi.Text;
        bool 是否置顶 = ShiFouZhiDing.Checked;
        bool 是否精华 = JingHuaTieZhi.Checked;
        bool 是否锁定 = SuoDingTieZhi.Checked;
        bool 是否删除 = ShanChuTieZhi.Checked;
        int 作者ID = Convert.ToInt32(ZuoZheID.Text);
        String 作者昵称 = new 用户(this.Context, 访问.连接).获取昵称(作者ID);
        int 所属版块 = Convert.ToInt32(SuoShuBanKuai.SelectedValue);
        int 贴子类型 = 0;
        if (TieZhiLeiXing_0.Checked)
            贴子类型 = 0;
        else if (TieZhiLeiXing_1.Checked)
            贴子类型 = 1;
        String 贴子内容 = TieZhiNeiRong.Text;

        if (标题.Length < 1 || 标题.Length > 50)
            throw new Exception("标题的长度必须在1-50之间");
        if (贴子内容.Length < 1)
            throw new Exception("贴子内容不能为空");

        String 所有文件 = 保存文件(ZGID, 贴子类型);
        int 模板_贴子内容 = Convert.ToInt32(MoBan_TieZhiNeiRong.SelectedValue);
        int 模板_回贴列表 = Convert.ToInt32(MoBan_HuiTieLieBiao.SelectedValue);
        int 模板_3G贴子内容 = Convert.ToInt32(MoBan_3GTieZhiNeiRong.SelectedValue);
        int 模板_3G回贴列表 = Convert.ToInt32(MoBan_3GHuiTieLieBiao.SelectedValue);
        String 投票选项 = TouPiaoXuanXiang.Text;

        String 文件夹位置 = 程序.安装位置 + "Data/DT_TieZhi/" + (ZGID /500) + "/";
        if (!Directory.Exists(Server.MapPath(文件夹位置)))
            Directory.CreateDirectory(Server.MapPath(文件夹位置));

        File.WriteAllText(Server.MapPath(文件夹位置 + ZGID + ".txt"), 贴子内容);

        SqlCommand 语句 = new SqlCommand("INSERT INTO [" + 程序.数据表前缀 + "社区_论坛_贴子]([ID],[标题],[贴子简介],[作者ID],[作者昵称],[是否置顶],[是否精华],[是否锁定],[是否删除],[贴子类型],[附件内容],[投票选项],[所属版块],[模板_贴子内容],[模板_回贴列表],[模板_3G贴子内容],[模板_3G回贴列表])" +
            "VALUES(" + ZGID + ",@标题,@贴子简介,@作者ID,@作者昵称,@是否置顶,@是否精华,@是否锁定,@是否删除,@贴子类型,@附件内容,@投票选项,@所属版块,@模板_贴子内容,@模板_回贴列表,@模板_3G贴子内容,@模板_3G回贴列表)", 访问.连接);
        语句.Parameters.Add("@标题", SqlDbType.NVarChar).Value = 标题;
        语句.Parameters.Add("@贴子简介", SqlDbType.NVarChar).Value = 常用.截取字符串(贴子内容, 100);
        语句.Parameters.Add("@作者ID", SqlDbType.Int).Value = 作者ID;
        语句.Parameters.Add("@作者昵称", SqlDbType.NVarChar).Value = 作者昵称;
        语句.Parameters.Add("@是否置顶", SqlDbType.Bit).Value = 是否置顶;
        语句.Parameters.Add("@是否精华", SqlDbType.Bit).Value = 是否精华;
        语句.Parameters.Add("@是否锁定", SqlDbType.Bit).Value = 是否锁定;
        语句.Parameters.Add("@是否删除", SqlDbType.Bit).Value = 是否删除;
        语句.Parameters.Add("@贴子类型", SqlDbType.Int).Value = 贴子类型;
        语句.Parameters.Add("@附件内容", SqlDbType.NVarChar).Value = 所有文件;
        语句.Parameters.Add("@投票选项", SqlDbType.NVarChar).Value = 投票选项;
        语句.Parameters.Add("@所属版块", SqlDbType.Int).Value = 所属版块;
        语句.Parameters.Add("@模板_贴子内容", SqlDbType.Int).Value = 模板_贴子内容;
        语句.Parameters.Add("@模板_回贴列表", SqlDbType.Int).Value = 模板_回贴列表;
        语句.Parameters.Add("@模板_3G贴子内容", SqlDbType.Int).Value = 模板_3G贴子内容;
        语句.Parameters.Add("@模板_3G回贴列表", SqlDbType.Int).Value = 模板_3G回贴列表;
        语句.ExecuteNonQuery();

        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("增加贴子", 访问.用户["昵称"].ToString());

        Response.Redirect("TieZhi.aspx");
    }
}
